/*
 * Decompiled with CFR 0.152.
 */
package tv.mapper.roadstuff.util;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.RegistryObject;
import tv.mapper.roadstuff.world.level.block.RSBlockRegistry;

public class ConcretePaintMap
extends Int2ObjectArrayMap<Block> {
    private static final long serialVersionUID = -2560468416060236377L;

    public ConcretePaintMap(boolean slope) {
        Block block;
        if (!slope) {
            this.register(0, 0, (Block)RSBlockRegistry.CONCRETE.get());
        } else if (slope) {
            this.register(0, 0, (Block)RSBlockRegistry.CONCRETE_SLOPE.get());
        }
        int index = 1;
        for (RegistryObject<Block> object : RSBlockRegistry.MOD_PAINTABLEBLOCKS) {
            block = (Block)object.get();
            if (!block.getRegistryName().toString().contains("concrete_") || !block.getRegistryName().toString().contains("_white_")) continue;
            if (block.getRegistryName().toString().contains("slope") && slope) {
                this.register(0, index, block);
                ++index;
                continue;
            }
            if (block.getRegistryName().toString().contains("slope") || slope) continue;
            this.register(0, index, block);
            ++index;
        }
        if (!slope) {
            this.register(1, 0, (Block)RSBlockRegistry.CONCRETE.get());
        } else if (slope) {
            this.register(1, 0, (Block)RSBlockRegistry.CONCRETE_SLOPE.get());
        }
        index = 1;
        for (RegistryObject<Block> object : RSBlockRegistry.MOD_PAINTABLEBLOCKS) {
            block = (Block)object.get();
            if (!block.getRegistryName().toString().contains("concrete_") || !block.getRegistryName().toString().contains("_yellow_")) continue;
            if (block.getRegistryName().toString().contains("slope") && slope) {
                this.register(1, index, block);
                ++index;
                continue;
            }
            if (block.getRegistryName().toString().contains("slope") || slope) continue;
            this.register(1, index, block);
            ++index;
        }
    }

    public void register(int color, int pattern, Block block) {
        int id = 0;
        if (color == 1) {
            id += 324;
        }
        this.put(id + pattern, block);
    }

    public Block getBlockFor(int color, int pattern) {
        int id = 0;
        if (color == 1) {
            id += 324;
        }
        return (Block)this.get(id + pattern);
    }

    public int[] getParamsFor(Block blockIn) {
        int color = 0;
        int pattern = 0;
        for (int i = 0; i < this.size(); ++i) {
            Block block = (Block)this.get(i);
            if (block != blockIn) continue;
            if (i >= 324) {
                color = 1;
                pattern = i - 324;
                continue;
            }
            pattern = i;
        }
        return new int[]{color, pattern};
    }
}

